using System;
using System.ComponentModel;
using System.Collections;
using Borland.Eco.Services;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.ObjectImplementation;
using Borland.Eco.UmlRt;
using Borland.Eco.UmlCodeAttributes;


namespace ChangeLogging
{

	[UmlCollection(typeof(Thing))]
	public interface IThingList : ICollection
	{
		#region ECO generated code
		Thing this[int index]
		{
			get;
			set;
		}
		int Add(Thing value);
		bool Contains(Thing value);
		int IndexOf(Thing value);
		void Insert(int index, Thing value);
		void Remove(Thing value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
	[UmlElement("Package", Id="0fb940cf-92d2-4703-b8e5-90366ff4b4fd")]
	[EcoCodeGenVersion("2.0")]
	[UmlMetaAttribute("ownedElement", typeof(Thing))]
	public abstract class CoreClassesPackage
	{
	}
	[UmlElement(Id="cb05b558-2348-4bb9-adb6-f7d82129c07e")]
	public class Thing : ILoopBack
	{
		
		public class ThingListAdapter : ObjectListAdapter, IThingList
		{
			public ThingListAdapter(IList source) : 
					base(source)
			{
			}
			public Thing this[int index]
			{
				get
				{
					return ((Thing)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Thing value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Thing value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Thing value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Thing value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Thing value)
			{
				this.Adaptee.Remove(value);
			}
		}
		
		#region Autogenerated ECO code
		
		public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;
		
		public Thing(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 1);
			public const int Name = Eco_FirstMember;
		}
		
		public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
		
		public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
		
		protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
		
		protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
		
		#endregion Autogenerated ECO code

		public Thing(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
				// User code here
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}

		[UmlElement(Id="ecd3833e-0736-459d-94b2-5dcc4b565aa1", Index=Eco_LoopbackIndices.Name)]
		public string Name
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Name)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Name, ((object)(value)));
			}
		}
	}
}
